using System;
using System.IO;

namespace SPStudio
{
	/// <summary>
	/// Handles File Reading and Writing in one Class
	/// </summary>
	public class FileHandler
	{
		#region Private Variables
		private StreamReader streamReader;
		private StreamWriter streamWriter;
		private String lineOut = "None";
		#endregion

		#region Constructor
		/// <summary>
		/// Standard Constructor 
		/// taking no params.
		/// </summary>
		public FileHandler()
		{
		}
		#endregion

		#region Code To Handle Reading A File
		/// <summary>
		/// Create an instance of StreamReader.
		/// Should the creation fail the Exception
		/// must be caught outside of this class.
		/// </summary>
		/// <param name="fileName"></param>
		public void setReadFile(String fileName)
		{
			streamReader = new StreamReader(fileName.Trim());
			lineOut = streamReader.ReadLine();
		}

		/// <summary>
		/// Returns the current line and advances
		/// to the next line. getLine() will assume
		/// that the end of the file has been reached
		/// if StreamReader.ReadLine() returns null
		/// or if the String returned by StreamReader.ReadLine()
		/// is empty.
		/// </summary>
		/// <returns></returns>
		public String getLine()
		{
			String temp = lineOut;
			lineOut = streamReader.ReadLine();
			if((lineOut!=null)&&(lineOut.Trim().Equals("")))
				lineOut=null;
			return temp;
		}

		/// <summary>
		/// If the line to be returned by
		/// getLine() would be null, then
		/// we have reached the end of the
		/// file.
		/// </summary>
		/// <returns></returns>
		public bool isEndOfFile()
		{
			if(lineOut==null) return true;
			return false;
		}
	
		/// <summary>
		/// Release the file.
		/// </summary>
		public void closeReader()
		{
			streamReader.Close();
		}
		#endregion

		#region Code To Handle Writing A File
		/// <summary>
		/// Create an instance of StreamWriter.
		/// Should the creation fail the Exception
		/// must be caught outside of this class.
		/// </summary>
		/// <param name="fileName"></param>
		public void setWriteFile(String fileName)
		{
			streamWriter = new StreamWriter(fileName.Trim());
		}

		/// <summary>
		/// Write the String out to the file
		/// as a line.
		/// </summary>
		/// <param name="inputString"></param>
		public void writeLine(String inputString)
		{
			streamWriter.WriteLine(inputString);
		}

		/// <summary>
		/// Write the String out to the file
		/// without the addition of newline.
		/// </summary>
		/// <param name="inputString"></param>
		public void write(String inputString)
		{
			streamWriter.Write(inputString);
		}

		/// <summary>
		/// Release the file.
		/// </summary>
		public void closeWriter()
		{
			streamWriter.Close();
		}
		#endregion
	}
}
